//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "Display.h"
#include "PacketDef.h"
#include <string.h>
#include <stdio.h>
//---------------------------------------------------------------------------
#pragma link "ComDrv32"
#pragma link "ComDrv32"
#pragma resource "*.dfm"
TDisplayForm *DisplayForm;
//---------------------------------------------------------------------------
__fastcall TDisplayForm::TDisplayForm(TComponent* Owner)
	: TForm(Owner)
{
  ComPort->ItemIndex = 0;
  Speed->ItemIndex = 9;

  Log->Items->Clear();
  lastNode = NULL;
}
//---------------------------------------------------------------------------
void __fastcall TDisplayForm::Button2Click(TObject *Sender)
{      
  Log->Items->Clear();
  lastNode = NULL;
}
//---------------------------------------------------------------------------
void __fastcall TDisplayForm::ComPortChange(TObject *Sender)
{
  SerialPort->ComPort = ComPort->ItemIndex;
}
//---------------------------------------------------------------------------
void __fastcall TDisplayForm::SpeedChange(TObject *Sender)
{
  SerialPort->ComPortSpeed = Speed->ItemIndex;
}
//---------------------------------------------------------------------------
void __fastcall TDisplayForm::SerialPortReceiveData(TObject *Sender,
      Pointer DataPtr, int DataSize)
{
  // Process the received data. The data is parsed a byte at a time.
  unsigned char *c = (unsigned char*)DataPtr;
  int p;
  char s[2024];
  unsigned char id, data;
  int field[10];

  for ( p = 0; p < DataSize; p++ ) {
    int packet = 0;
    bool found = false;

    id = c[p];

    while ( gPacketDef[packet].packetID != kLastID ) {
      if ( gPacketDef[packet].packetID == (id&(~kSubItemBit)) ) {
        found = true;
        break;
      }
      packet++;
    }
    if ( !found ) {
      sprintf(s, "### Error: Unknown packet ID (%d)", c[p]&(~kSubItemBit) );
      lastNode = Log->Items->Add(NULL, s );
      continue;
    }

    if ( strchr( gPacketDef[packet].packetDescription, '%' ) )
      data = c[++p];

    char *ss = gPacketDef[packet].packetFields;
    int fieldNum = 0;
    while ( *ss ) {
      switch( *ss ) {
      case 'I':
        field[fieldNum++] = data;
        break;

      case 'S':
        char stringClass[100];
        int k = 0;
        ss += 2;
        while (*ss != ']' )
          stringClass[k++] = *ss++;
        stringClass[k] = '\0';
        bool found = false;
        k = 0;
        while ( gStringDef[k].stringClass ) {
          if ( !strcmp( gStringDef[k].stringClass, stringClass )
                && data == gStringDef[k].data ) {
            field[fieldNum++] = (int)gStringDef[k].text;
            found = true;
            break;
          }
          k++;
        }
        if ( !found )
          field[fieldNum++] = (int)&"### Unknown ###";
        break;
      }
      ss++;
    }

    sprintf(s, gPacketDef[packet].packetDescription, field[0], field[1], field[2], field[3], field[4], field[5], field[6]);
    if ( (id & kSubItemBit) != 0 )
      Log->Items->AddChild(lastNode, s );
    else
      lastNode = Log->Items->Add(NULL, s );
  }
}
//---------------------------------------------------------------------------
void __fastcall TDisplayForm::Button1Click(TObject *Sender)
{
  if ( SerialPort->Connected() )
    SerialPort->Disconnect();

  if ( !SerialPort->Connect() )
    Log->Items->AddFirst(NULL, "### Error: Could not connect to serial port" );
}
//---------------------------------------------------------------------------
void __fastcall TDisplayForm::Button3Click(TObject *Sender)
{
  if ( SerialPort->Connected() )
    SerialPort->Disconnect();
}
//---------------------------------------------------------------------------

